/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "myriexpress.h"
#include "test_common.h"

int main(void)
{
  mx_return_t ret;

  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_finalize();
  insist(ret == MX_NOT_INITIALIZED);

  ret = mx_init();
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_NOT_INITIALIZED);

  mx_finalize();
  printf("[PASS]\n");
  fflush(stdout);
  return 0;
}
